<?php

class Termin{
	private $id;
	private $klasse;
	private $fach;
	private $lehrer;
	private $raum;
	private $tag;
	private $beginn;
	private $ende;
	
	public function __construct(){
		$this->klasse = new Klasse();
		$this->fach = new Fach();
		$this->lehrer = new Lehrer();
		$this->raum = new Raum();
		$this->tag = NULL;
		$this->beginn = NULL;
		$this->ende = NULL;	
	}
	public function getId(){
		return $this->id;	
	}
	public function setId($wert){
		$this->id = $wert;
	}
	public function getKlasse(){
		return $this->klasse;	
	}
	public function setKlasse($objekt){
		if($objekt instanceof Klasse) $this->klasse = $objekt;
		else throw new Exception('Der Parameter fr setKlasse ist nicht vom Typ Klasse!');	
	}
	public function getFach(){
		return $this->fach;	
	}
	public function setFach($objekt){
		if($objekt instanceof Fach) $this->fach = $objekt;
		else throw new Exception('Der Parameter fr setFach ist nicht vom Typ Fach!');	
	}
	public function getLehrer(){
		return $this->lehrer;	
	}
	public function setLehrer($objekt){
		if($objekt instanceof Lehrer) $this->lehrer = $objekt;
		else throw new Exception('Der Parameter fr setLehrer ist nicht vom Typ Lehrer!');	
	}
	public function getRaum(){
		return $this->raum;	
	}
	public function setRaum($objekt){
		if($objekt instanceof Raum) $this->raum = $objekt;
		else throw new Exception('Der Parameter fr setRaum ist nicht vom Typ Raum!');	
	}
	public function getTag(){
		return $this->tag;	
	}
	public function setTag($wert){
		if(is_numeric($wert) && $wert>=1 && $wert <= 7){
			$this->tag = $wert;
		}
		else{
			 throw new Exception('Der Parameter fr setTag liegt auerhalb des Wertebereichs!');	
		}	
	}
	public function getBeginn(){
		return $this->beginn;	
	}
	public function setBeginn($wert){
		$this->beginn = $wert;
	}
	public function getEnde(){
		return $this->ende;	
	}
	public function setEnde($wert){
		$this->ende = $wert;
	}
	public function getXML(){
		$xmlString = '<termin id="'.$this->getId().'" tag="'.$this->getTag().'" beginn="'.$this->getBeginn().'" ende ="'.$this->getEnde().'" >';
			$xmlString.= '<id>'.$this->getId().'</id>';
			$xmlString.= $this->getKlasse()->getXML(); 
			$xmlString.= $this->getFach()->getXML();
			$xmlString.= $this->getLehrer()->getXML();
			$xmlString.= $this->getRaum()->getXML();
			$xmlString.= '<tag>'.$this->getTag().'</tag>';
			$xmlString.= '<beginn>'.$this->getBeginn().'</beginn>';
			$xmlString.= '<ende>'.$this->getEnde().'</ende>';
		$xmlString.= "</termin>";
		return $xmlString;
	}
}

?>
